/*
 * Decompiled with CFR 0.152.
 */
package ecka;

import ecka.Main;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import net.mypapit.java.StringTokenizer;

class GCanvas
extends Canvas {
    private final Main canvas;
    int state = 0;
    String currentLine = "";
    int ctr;
    boolean displayingInfo;
    Vector records = new Vector();
    int[] Colors = new int[]{0xAAAAAA, 0x22AA00, 0xFFFFFF, 16756890, 0xFF7777, 0xFF0000};
    Vector prevLines = new Vector();
    boolean checkingTouchmode = true;
    int vkYStart;
    int vkRectW;
    int vkRectH;
    int vkSpace;
    int LINE;

    GCanvas(Main main) {
        this.canvas = main;
    }

    public void paint(Graphics g) {
        int x;
        System.out.println("a");
        if (this.LINE == 0) {
            if (g.getFont() == null) {
                g.setFont(Font.getDefaultFont());
            }
            this.LINE = g.getFont().getHeight() * 4 / 3;
        }
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.checkingTouchmode) {
            g.setColor(0xCCCCCC);
            g.drawString("Klepni na displej pro", 5, 20, 20);
            g.drawString("dotykove ovladani.", 5, 20 + g.getFont().getHeight(), 20);
            g.drawString("Jinak stiskni cokoliv.", 5, 20 + 4 * g.getFont().getHeight(), 20);
            return;
        }
        g.setColor(0xFFFFFF);
        g.drawString("Tabulka E-cek", this.getWidth() / 2, this.LINE / 2 + this.LINE / 5, 65);
        g.setColor(0x888888);
        g.drawLine(0, this.LINE, this.getWidth(), this.LINE);
        g.setColor(0xFF55FF);
        g.drawString(this.currentLine, 10, this.LINE + 2, 20);
        if (g.getFont() == null) {
            g.setFont(Font.getDefaultFont());
        }
        int swidth = g.getFont().stringWidth(this.currentLine);
        g.setColor(0xFFFFFF);
        if (this.ctr++ % 20 < 10) {
            g.drawLine(10 + swidth + 1, this.LINE + 2, 10 + swidth + 1, this.LINE + 2 + g.getFont().getHeight());
        }
        if (this.prevLines == null) {
            this.prevLines = new Vector();
        }
        if (this.displayingInfo || this.prevLines.size() > 0) {
            x = 5;
            int y = this.LINE + 2 + g.getFont().getHeight() + 5;
            int i = 0;
            while (i < this.records.size()) {
                Main.RecordInfo ri = (Main.RecordInfo)this.records.elementAt(i);
                g.setColor(this.Colors[ri.severity + 1]);
                if (x + g.getFont().stringWidth(ri.token) >= this.getWidth() - 1) {
                    x = 5;
                    y += g.getFont().getHeight();
                }
                g.drawString(ri.token, x, y, 20);
                x += g.getFont().stringWidth(ri.token) + 5;
                ++i;
            }
            int j = 0;
            while (j < this.prevLines.size()) {
                x = 5;
                y += g.getFont().getHeight();
                Vector prev = (Vector)this.prevLines.elementAt(j);
                int i2 = 0;
                while (i2 < prev.size()) {
                    Main.RecordInfo ri = (Main.RecordInfo)prev.elementAt(i2);
                    g.setColor(this.Colors[ri.severity + 1]);
                    if (x + g.getFont().stringWidth(ri.token) >= this.getWidth() - 8) {
                        x = 5;
                        y += g.getFont().getHeight();
                    }
                    g.drawString(ri.token, x, y, 20);
                    x += g.getFont().stringWidth(ri.token) + 5;
                    if (y > this.getHeight()) break;
                    ++i2;
                }
                if (y > this.getHeight()) break;
                ++j;
            }
        }
        if (this.canvas.touchmode) {
            this.drawKeypad(g);
        }
        x = this.getWidth() - 7;
        int c = 0;
        int y = 0;
        while (y < this.getHeight()) {
            g.setColor(this.Colors[++c]);
            g.fillRect(x, y, 7, this.getHeight() / 5);
            y += this.getHeight() / 5;
        }
    }

    private void drawKeypad(Graphics g) {
        int x = this.vkRectW / 2;
        int y = this.vkYStart + this.vkRectH / 2;
        g.setColor(0x225533);
        g.fillRect(0, this.vkYStart, this.getWidth(), this.getWidth());
        g.setColor(0xAAFFFF);
        g.translate(0, this.LINE / 5);
        g.drawString("1", x, y, 65);
        g.drawString("2", x + this.vkRectW, y, 65);
        g.drawString("3", x + this.vkRectW + this.vkRectW, y, 65);
        g.drawString("4", x, y + this.vkRectH, 65);
        g.drawString("5", x + this.vkRectW, y + this.vkRectH, 65);
        g.drawString("6", x + this.vkRectW + this.vkRectW, y + this.vkRectH, 65);
        g.drawString("7", x, y + this.vkRectH + this.vkRectH, 65);
        g.drawString("8", x + this.vkRectW, y + this.vkRectH + this.vkRectH, 65);
        g.drawString("9", x + this.vkRectW + this.vkRectW, y + this.vkRectH + this.vkRectH, 65);
        g.drawString("space", x, y + this.vkRectH + this.vkRectH + this.vkRectH, 65);
        g.drawString("0", x + this.vkRectW, y + this.vkRectH + this.vkRectH + this.vkRectH, 65);
        g.drawString("CLR", x + this.vkRectW + this.vkRectW, y + this.vkRectH + this.vkRectH + this.vkRectH, 65);
        g.translate(0, -this.LINE / 5);
        g.setColor(0x225533);
        g.fillRect(0, 0, this.getWidth() / 5, this.LINE);
        g.setColor(0x779277);
        g.drawRect(0, 0, this.getWidth() / 5, this.LINE);
        g.setColor(0xAAFFFF);
        g.drawString("OK", this.getWidth() / 10, this.LINE / 2 + this.LINE / 4, 65);
        g.setColor(0x779277);
        g.drawLine(0, this.vkYStart, this.getWidth(), this.vkYStart);
        g.drawLine(0, this.vkYStart + this.vkRectH, this.getWidth(), this.vkYStart + this.vkRectH);
        g.drawLine(0, this.vkYStart + this.vkRectH + this.vkRectH, this.getWidth(), this.vkYStart + this.vkRectH + this.vkRectH);
        g.drawLine(0, this.vkYStart + this.vkRectH + this.vkRectH + this.vkRectH, this.getWidth(), this.vkYStart + this.vkRectH + this.vkRectH + this.vkRectH);
        g.drawLine(this.vkRectW, this.vkYStart, this.vkRectW, this.getHeight());
        g.drawLine(this.vkRectW * 2, this.vkYStart, this.vkRectW * 2, this.getHeight());
        g.drawLine(this.vkRectW * 3, this.vkYStart, this.vkRectW * 3, this.getHeight());
        g.drawLine(this.vkRectW * 4, this.vkYStart, this.vkRectW * 4, this.getHeight());
    }

    public void init() {
    }

    protected void pointerPressed(int xx, int yy) {
        block10: {
            block11: {
                block9: {
                    if (!this.checkingTouchmode) break block9;
                    this.checkingTouchmode = false;
                    this.canvas.touchmode = true;
                    this.vkYStart = this.getHeight() - this.getHeight() * 2 / 5;
                    this.vkSpace = this.getHeight() - this.vkYStart;
                    this.vkRectH = this.vkSpace / 4;
                    this.vkRectW = this.getWidth() / 3;
                    break block10;
                }
                if (!this.canvas.touchmode) break block10;
                if (yy <= this.vkYStart) break block11;
                int x = xx / this.vkRectW;
                int y = (yy -= this.vkYStart) / this.vkRectH;
                int pos = x + y * 3;
                switch (pos) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentLine = String.valueOf(this.currentLine) + (pos + 1);
                        break;
                    }
                    case 10: {
                        this.currentLine = String.valueOf(this.currentLine) + "0";
                        break;
                    }
                    case 9: {
                        this.currentLine = String.valueOf(this.currentLine) + ",";
                        break;
                    }
                    case 11: {
                        if (this.currentLine.length() <= 0) break block10;
                        this.currentLine = this.currentLine.substring(0, this.currentLine.length() - 1);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block10;
            }
            if (xx < this.getWidth() / 4 && yy <= this.LINE + this.LINE / 2) {
                this.displayInfo(this.currentLine);
                this.currentLine = "";
            }
        }
    }

    protected void keyPressed(int arg0) {
        if (this.checkingTouchmode) {
            this.checkingTouchmode = false;
            return;
        }
        if (arg0 == 35) {
            if (this.currentLine.length() > 0) {
                this.currentLine = this.currentLine.substring(0, this.currentLine.length() - 1);
            }
        } else if (arg0 == 42) {
            this.currentLine = String.valueOf(this.currentLine) + ",";
        } else if (arg0 - 48 >= 0 && arg0 - 48 <= 9) {
            this.currentLine = String.valueOf(this.currentLine) + (arg0 - 48);
        } else if (this.canvas.canvas.getGameAction(arg0) == 8) {
            this.displayInfo(this.currentLine);
            this.currentLine = "";
        }
    }

    int getSeverity(String t) {
        if (t.equals(this.canvas.TOKEN_POISON)) {
            return 4;
        }
        if (t.equals(this.canvas.TOKEN_BAD)) {
            return 3;
        }
        if (t.equals(this.canvas.TOKEN_NOT_OK)) {
            return 2;
        }
        if (t.equals(this.canvas.TOKEN_OK)) {
            return 1;
        }
        if (t.equals(this.canvas.TOKEN_GOOD)) {
            return 0;
        }
        return -1;
    }

    public void displayInfo(String line) {
        System.out.println("disp in");
        if (line.equals("000")) {
            this.canvas.exit = true;
            return;
        }
        if (this.records.size() > 0) {
            Vector v = new Vector();
            int i = 0;
            while (i < this.records.size()) {
                v.addElement(this.records.elementAt(i));
                ++i;
            }
            this.prevLines.insertElementAt(v, 0);
        }
        this.records.removeAllElements();
        StringTokenizer stok = new StringTokenizer(this.currentLine, ",");
        while (stok.hasMoreTokens()) {
            String t = stok.nextToken();
            String severity = (String)this.canvas.table.get(t);
            boolean edded = false;
            char[] sylabs = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'};
            int i = 0;
            while (i < sylabs.length) {
                String newt = String.valueOf(t) + sylabs[i];
                String nseverity = (String)this.canvas.table.get(newt);
                if (nseverity != null) {
                    Main.RecordInfo r = new Main.RecordInfo();
                    r.token = newt;
                    r.severity = this.getSeverity(nseverity);
                    this.records.addElement(r);
                    edded = true;
                }
                ++i;
            }
            if (severity != null) {
                Main.RecordInfo r = new Main.RecordInfo();
                r.token = t;
                r.severity = this.getSeverity(severity);
                this.records.addElement(r);
                edded = true;
            }
            if (edded) continue;
            Main.RecordInfo r = new Main.RecordInfo();
            r.token = t;
            r.severity = -1;
            this.records.addElement(r);
        }
        this.displayingInfo = this.records.size() > 0;
        System.out.println("disp out");
    }
}

